unit plug;

interface

uses
  windows;

type
  // feedback info record
  TPlugunInfo = packed record
    Name        : PChar;
    IsBench     : Boolean;
    IsInfo      : Boolean;
    BenchName   : PChar;
    InfoName    : PChar;
    IsUseOpenGL : Boolean;  // not used yet
  end;

  // battery info record
  TBatteryInfo = packed record
    Present     : Boolean;
    Capacity    : cardinal;
    Voltage     : cardinal;
    Percent     : Single;
  end;

  // plugin version
  TplugInVersion = packed record
    Major    : Byte;
    Minor    : Byte;
    Revision : Byte;
    plugins  : Word;
    Comment  : PChar;
  end;

  BeginBenchmark = procedure;
  SetAutoRun = procedure(ProgTitle, CmdLine: string; RunOnce: boolean);
  GetBatteryInfo = Function(BatNumber : Byte) : TBatteryInfo;
  AddStringToLog = function(St : String) : Boolean;
  GetPluginVersion = function : TplugInVersion;
  DrawInfoText = Procedure (X, Y, Size : Word; Text : PChar);

Var
  beBeginBenchmark : BeginBenchmark;
  beSetAutoRun : SetAutoRun;
  beGetBatteryInfo : GetBatteryInfo;
  beAddStringToLog : AddStringToLog;
  beGetPluginVersion : GetPluginVersion;
  beDrawInfoText : DrawInfoText;
  Owner : Cardinal;                    // main app handle
  h_wnd : HWND;                        // main window handle

Procedure InitializePlugin;  

implementation

Procedure InitializePlugin;
begin
  beBeginBenchmark:= GetProcAddress(Owner, 'BeginBenchmark');
  beSetAutoRun:= GetProcAddress(Owner, 'SetAutoRun');
  beGetBatteryInfo:= GetProcAddress(Owner, 'GetBatteryInfo');
  beAddStringToLog:= GetProcAddress(Owner, 'AddStringToLog');
  beGetPluginVersion:= GetProcAddress(Owner, 'GetPluginVersion');
  beDrawInfoText:= GetProcAddress(Owner, 'DrawInfoText');
end;

end.
